/*
This software module was originally developed by 
        Hang-Seop Lee (hslee@etri.re.kr), ETRI
        Jung-Chul Lee (jclee@etri.re.kr), ETRI
and edited by Hang-Seop Lee, Jung-Chul Lee of ETRI, 
in the course of development of the MPEG-4.
This software module is an implementation of a part of one or
more MPEG-4 tools as specified by the MPEG-4.
ISO/IEC gives users of the MPEG-4 free license to this                
software module or modifications thereof for use in hardware
or software products claiming conformance to the MPEG-4.
Those intending to use this software module in hardware or software
products are advised that its use may infringe existing patents.
The original developer of this software module and his/her company,
the subsequent editors and their companies, and ISO/IEC have no
liability for use of this software module or modifications thereof
in an implementation.
Copyright is not released for non MPEG-4 conforming
products. ETRI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to
inhibit third parties from using the code for non
MPEG-4 conforming products.
This copyright notice must be included in all copies or
derivative works. Copyright (c) 1997.
*/    

// ModelessDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Modeless.h"
#include "ModelessDlg.h"
#include "ModelessOptDlg.h"		// for CModelessOptDlg class
#include "LipSyncDlg.h"			// for CLipSyncDlg class
#include "ModelessTextDlg.h"	// for ModelessTextDlg class
#include "AboutDlg.h"			// for AboutDlg class
#include "EncoderDlg.h"			// for CEncoderDlg class
#include "vsay.h"
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CModelessDlg*	ppp;

extern	CModelessOptDlg* pOpt;
extern	CLipSyncDlg*	pCLip;
extern	CModelessTextDlg* pText;
extern char	szTEXTSTRING[800];
extern char	szONESENTENCE[100][200];
extern int	nS_MAX;
extern int	nFILE;
extern int	nSENTENCE;
extern int	IsVideo;	// from TTS

int		nFlag_Stop = 1;
int		nPOS, nPOS_MOV;
float	f_CURPOS, f_CURPOS_F, f_SPCHRATE;	
int		nFLAG_TRICK; 

/////////////////////////////////////////////////////////////////////////////
// CModelessDlg dialog

CModelessDlg::CModelessDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CModelessDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModelessDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pMSDlg = new CModelessOptDlg(this);	
	// create the dialog if not create already
	if( m_pMSDlg->GetSafeHwnd() == 0 )
	{
		if( m_pMSDlg->Create() == 0 )		// display the dialog window
		{
			AfxMessageBox("Failure of Modeless Dialog Open");
		}
	}

	HWND hFAWnd;
	m_pLipDlg = new CLipSyncDlg(this);	
	// create the dialog if not create already
	if( (hFAWnd = m_pLipDlg->GetSafeHwnd()) == 0 )
	{
		if( m_pLipDlg->Create() == 0 )		// display the dialog window
		{
			AfxMessageBox("Failure of Lip Modeless Dialog Open");
		}
	}


	m_pEncoderDlg = new CEncoderDlg(this);	
	// create the dialog if not create already
	if( m_pEncoderDlg->GetSafeHwnd() == 0 )
	{
		if( m_pEncoderDlg->Create() == 0 )		// display the dialog window
		{
			AfxMessageBox("Failure of Encoder Modeless Dialog Open");
		}
	}


}

// insert by ׼
CModelessDlg::~CModelessDlg()
{
	// no problem if window was already destroyed
	m_pMSDlg->DestroyWindow();
	m_pLipDlg->DestroyWindow();
	m_pEncoderDlg->DestroyWindow();
	
	delete m_pMSDlg;		// destroys window if not already destroyed
	delete m_pLipDlg;		// destroys window if not already destroyed
	delete m_pEncoderDlg;		// destroys window if not already destroyed
}

void CModelessDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModelessDlg)
	DDX_Control(pDX, IDOK, m_button_exit);
	DDX_Control(pDX, IDC_F_Position, m_slider_position_F);
	DDX_Control(pDX, IDC_S_Position, m_slider_position);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CModelessDlg, CDialog)
	ON_MESSAGE(WM_GOODBYE, OnGoodbye)	// insert by ׼
	//{{AFX_MSG_MAP(CModelessDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_B_Play, OnBPlay)
	ON_BN_CLICKED(IDC_B_Pause, OnBPause)
	ON_BN_CLICKED(IDC_B_Resume, OnBResume)
	ON_BN_CLICKED(IDC_B_STOP, OnBStop)
	ON_BN_CLICKED(IDC_B_BACKWARD, OnBBackward)
	ON_BN_CLICKED(IDC_B_FORWARD, OnBForward)
	ON_BN_CLICKED(IDC_B_About, OnBAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelessDlg message handlers

BOOL CModelessDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	MoveWindow( 0, 1, 799, 140 );

	ppp = this;
	VERIFY(m_editPlay.AutoLoad(IDC_B_Play, this));
	VERIFY(m_editPause.AutoLoad(IDC_B_Pause, this));
	VERIFY(m_editResume.AutoLoad(IDC_B_Resume, this));
	VERIFY(m_editStop.AutoLoad(IDC_B_STOP, this));
	VERIFY(m_editBackward.AutoLoad(IDC_B_BACKWARD, this));
	VERIFY(m_editForward.AutoLoad(IDC_B_FORWARD, this));

	m_editPlay.EnableWindow(FALSE);
	m_editPause.EnableWindow(FALSE);
	m_editResume.EnableWindow(FALSE);
	m_editStop.EnableWindow(FALSE);
	m_editBackward.EnableWindow(FALSE);
	m_editForward.EnableWindow(FALSE);

	nPOS = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CModelessDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CModelessDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

LONG CModelessDlg::OnGoodbye(UINT wParam, LONG lParam)
{
	TRACE("CModelessDlg::OnGoodbye is called");
	m_pMSDlg->DestroyWindow();
	return 0L;
}

DWORD dwThreadID_TTS;		// for Thread
HANDLE hThread_TTS;			// for Thread
// Thread function for Synthesized Sound Output
void Thread_TTS()
{
		
		MPEG4_TTS_Play();

		pCLip->ChangeBitmap(0);
		ppp->m_editPlay.EnableWindow(TRUE);
		ppp->m_editPause.EnableWindow(FALSE);
		ppp->m_editResume.EnableWindow(FALSE);
		ppp->m_editStop.EnableWindow(FALSE);
		if( nFLAG_TRICK )
		{
			ppp->m_editBackward.EnableWindow(TRUE);
			ppp->m_editForward.EnableWindow(TRUE);
		}
		ppp->m_slider_position.SetPos(0);
		ppp->m_slider_position_F.SetPos(0);

		// Thread is done successfully
		nFlag_Stop = 1;
}


// push the Play Button
void CModelessDlg::OnBPlay() 
{
	// TODO: Add your control notification handler code here


	if( IsVideo )	// for moving picture
	{
		//  õ 峻 ġ  slider position
		nPOS_MOV = ppp->m_slider_position.GetPos();
		if( !nFLAG_TRICK )	nPOS_MOV = 0;
	}
	else
	{
		int nPos_f;	
		if( !nFLAG_TRICK )
			m_slider_position_F.SetPos(0);
		//  Ű slider position
		nPos_f = m_slider_position_F.GetPos();
		// VoiceSay.cpp   ֵ
		f_CURPOS_F = (float)nPos_f;
		
	}

	f_SPCHRATE = (float)pOpt->m_slider_SpchRate.GetPos();

	if( (hThread_TTS = ::CreateThread((LPSECURITY_ATTRIBUTES)NULL, 
		0,				// initial thread stack size, in bytes 
		(LPTHREAD_START_ROUTINE) Thread_TTS,	// pointer to thread function 
		(LPVOID)NULL,	// argument for new thread 
		0,				// creation flags 
		(LPDWORD) &dwThreadID_TTS 	// pointer to returned thread identifier 
		)) == NULL )
	{
		AfxMessageBox( "CreatThread Error" );
	}
	else
	{
		nFlag_Stop = 0;		// TTS Thread  ˸
		m_editPlay.EnableWindow(FALSE);
		if( nFLAG_TRICK )
		{
			m_editPause.EnableWindow(TRUE);
			m_editResume.EnableWindow(FALSE);
		}
		m_editStop.EnableWindow(TRUE);
	}
}

// push the Pause Button
void CModelessDlg::OnBPause() 
{
	// TODO: Add your control notification handler code here
	m_editPlay.EnableWindow(FALSE);
	m_editPause.EnableWindow(FALSE);
	m_editResume.EnableWindow(TRUE);
	m_editStop.EnableWindow(TRUE);
	m_editBackward.EnableWindow(FALSE);
	m_editForward.EnableWindow(FALSE);

	SoundOutPause();
	
}

// push the Resume Button
void CModelessDlg::OnBResume() 
{
	// TODO: Add your control notification handler code here
	m_editPlay.EnableWindow(FALSE);
	m_editPause.EnableWindow(TRUE);
	m_editResume.EnableWindow(FALSE);
	m_editStop.EnableWindow(TRUE);
	m_editBackward.EnableWindow(FALSE);
	m_editForward.EnableWindow(FALSE);
	
	f_SPCHRATE = (float)pOpt->m_slider_SpchRate.GetPos();

	SoundOutRestart();
}

// push the Stop Button
void CModelessDlg::OnBStop() 
{
	// TODO: Add your control notification handler code here

	DWORD  lpExitCode;	// address to receive termination status 

	if( GetExitCodeThread(hThread_TTS,	// handle to the thread 
		(LPDWORD)&lpExitCode 	// address to receive termination status 
		) == FALSE )
	{
		AfxMessageBox( "GetExitCodeThread " );
	}
	else if( TerminateThread( hThread_TTS, lpExitCode ) == FALSE )
	{
		AfxMessageBox( "TerminateThread " );
	}
	else
	{
		m_editPlay.EnableWindow(TRUE);
		m_editPause.EnableWindow(FALSE);
		m_editResume.EnableWindow(FALSE);
		m_editStop.EnableWindow(FALSE);
		if( nFLAG_TRICK )
		{
			m_editBackward.EnableWindow(TRUE);
			m_editForward.EnableWindow(TRUE);
		}
		pCLip->ChangeBitmap(0);	// Lip
		SoundOutStop();
		// TTS Thread terminate Ǿ ˸
		nFlag_Stop = 1;
	}
	
}

// push the Backward Button
void CModelessDlg::OnBBackward() 
{
	// TODO: Add your control notification handler code here
	if (nFlag_Stop == 0)	OnBStop();

	if( IsVideo )	// for moving picture
	{
		nPOS_MOV = m_slider_position.GetPos();
		if( (nPOS_MOV -= 1) < 0 )	nPOS_MOV = 0;
		m_slider_position.SetPos(nPOS_MOV);
	}
	else
	{
		nPOS = m_slider_position_F.GetPos();
		if( (nPOS -= 1) < 0 )	nPOS = 0;
		m_slider_position_F.SetPos(nPOS);
	}

}

// push the Forward Button
void CModelessDlg::OnBForward() 
{
	// TODO: Add your control notification handler code here
	if (nFlag_Stop == 0)	OnBStop();

	if( IsVideo )	// for moving picture
	{
		nPOS_MOV = m_slider_position.GetPos();
		if( (nPOS_MOV += 1) > nS_MAX )	nPOS_MOV = nS_MAX;
		m_slider_position.SetPos(nPOS_MOV);
	}
	else
	{
		nPOS = m_slider_position_F.GetPos();
		if( (nPOS += 1) > nS_MAX )	nPOS = nS_MAX;
		m_slider_position_F.SetPos(nPOS);
	}

}


void CModelessDlg::OnBAbout() 
{
	// TODO: Add your control notification handler code here
	CAboutDlg	dlg;

	dlg.DoModal() == IDOK;
}

void CModelessDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// in case of Thread activating
	if (nFlag_Stop == 0)	OnBStop();

	CDialog::OnOK();

}

// called in ModelessOptDlg.cpp
void CModelessDlg::CallOnPlay()
{
	OnBPlay();
}
